package com.onsiteservice.miniapp.service.log;

import com.onsiteservice.entity.service.ServiceOrderLog;
import com.onsiteservice.dao.mapper.service.ServiceOrderLogMapper;
import com.onsiteservice.miniapp.mapper.service.ServiceOrderLogBizMapper;

import com.onsiteservice.dao.common.AbstractMapper;
import com.onsiteservice.dao.common.page.PageParams;
import com.onsiteservice.dao.common.page.PageInfoVO;
import com.github.pagehelper.PageHelper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;

/**
 * @author 潘维吉
 * @date 2022-07-11 11:37
 * @description ServiceOrderLogService服务类
 */
@Service
@Transactional(rollbackFor = Exception.class)
public class ServiceOrderLogService extends AbstractMapper<ServiceOrderLog> {

    @Resource
    private ServiceOrderLogMapper serviceOrderLogMapper;
    @Resource
    private ServiceOrderLogBizMapper serviceOrderLogBizMapper;

    /**
     * 分页查询列表
     */
    public PageInfoVO getPage(PageParams param) {
        PageHelper.startPage(param.getPage(), param.getSize());
        return new PageInfoVO(this.selectAll());
    }

    /**
     * 保存或更新方法
     */
    public int saveOrUpdate(ServiceOrderLog serviceOrderLog) {
        if (serviceOrderLog.getId() == null) {
            return this.insertSelective(serviceOrderLog);
        } else {
            return this.updateByPrimaryKeySelective(serviceOrderLog);
        }
    }
}
