package com.onsiteservice.miniapp.controller.worker;

import com.onsiteservice.core.result.Result;
import com.onsiteservice.miniapp.controller.worker.vo.ServiceWorkerVO;
import com.onsiteservice.miniapp.service.worker.ServiceWorkerService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

import static com.onsiteservice.core.result.ResultGenerator.success;

/**
 * <P>维修工模块</P>
 *
 * @author 李宁
 * @version v1.0
 * @since 2022/7/11 08:51
 */
@Api(tags = "维修工模块")
@RestController
@RequestMapping("/worker/")
@Validated
public class ServiceWorkerController {

    @Resource
    private ServiceWorkerService serviceWorkerService;


//    @ApiOperation(value = "查询全部维修工")
//    @GetMapping("all")
//    public Result<List<ServiceWorkerVO>> all() {
//        return success(serviceWorkerService.all());
//    }

    @ApiOperation(value = "根据姓名查询")
    @GetMapping("get")
    public Result<List<ServiceWorkerVO>> getDetails(@ApiParam(name = "name", value = "维修工姓名") @RequestParam(required = false) String name) {
        return success(serviceWorkerService.selectByName(name));
    }


}
