package com.onsiteservice.miniapp.controller.user.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@Data
public class UserInfoVO {

    /**
     * 主键
     */
    @ApiModelProperty("主键")
    private Long id;


    /**
     * 用户名
     */
    @ApiModelProperty("用户名")
    private String userName;

    @ApiModelProperty("昵称")
    private String nickName;

    @ApiModelProperty("手机号")
    private String phone;

    @ApiModelProperty("邮箱")
    private String email;

    /**
     * 头像
     */
    @ApiModelProperty("头像")
    private String avatar;


    @ApiModelProperty("性别")
    private String sex;

    @ApiModelProperty("0 普通用户 1 客服 2 估价员 3 销售")
    private Integer roleType;

    @ApiModelProperty("待处理数量（客服用户）")
    private Integer todo;

    @ApiModelProperty("订单信息")
    private List<UserOrderInfoVO> orderInfo;
}
