package com.onsiteservice.entity.user;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

@Getter
@Setter
@ToString
@ApiModel("小程序登录日志表")
@Table(name = "user_login_log")
public class UserLoginLog implements Serializable {
    /**
     * 主键
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty("主键")
    private Long id;

    /**
     * 用户id
     */
    @Column(name = "user_id")
    @ApiModelProperty("用户id")
    private Long userId;

    /**
     * 设备型号
     */
    @Column(name = "device_type")
    @ApiModelProperty("设备型号")
    private String deviceType;

    /**
     * 设备系统
     */
    @Column(name = "device_system")
    @ApiModelProperty("设备系统")
    private String deviceSystem;

    /**
     * 系统版本
     */
    @Column(name = "os_version")
    @ApiModelProperty("系统版本")
    private String osVersion;

    /**
     * 微信版本
     */
    @Column(name = "wechat_version")
    @ApiModelProperty("微信版本")
    private String wechatVersion;

    /**
     * 应用版本
     */
    @Column(name = "application_version")
    @ApiModelProperty("应用版本")
    private String applicationVersion;

    /**
     * 创建时间
     */
    @Column(name = "create_time")
    @ApiModelProperty("创建时间")
    private Date createTime;

    private static final long serialVersionUID = 1L;
}
