package com.onsiteservice.entity.sys;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

@Getter
@Setter
@ToString
@NoArgsConstructor
@AllArgsConstructor
@Builder
@ApiModel("系统配置参数表")
@Table(name = "sys_param")
public class SysParam implements Serializable {
    /**
     * 主键
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty("主键")
    private Long id;

    /**
     * 类型 : 1 整型 2 字符串  3 富文本 4 图片 5 文件
     * @see com.property.sales.constant.DictConstants.SYS_PARAM_TYPE
     */
    @ApiModelProperty("SYS0005 类型 : 1 整型 2 字符串  3 富文本 4 图片 5 文件")
    private Integer type;

    /**
     * 编号
     */
    @ApiModelProperty("编号")
    private String code;

    /**
     * 参数名
     */
    @ApiModelProperty("参数名")
    private String name;

    /**
     * 参数值
     */
    @ApiModelProperty("参数值")
    private String value;

    /**
     * 备注
     */
    @ApiModelProperty("备注")
    private String remark;

    /**
     * 显示排序号 数字越大优先级越高
     */
    @Column(name = "show_order")
    @ApiModelProperty("显示排序号 数字越大优先级越高")
    private Integer showOrder;

    /**
     * 是否删除 0: 未删除 1: 已删除
     */
    @Column(name = "is_deleted")
    @ApiModelProperty("是否删除 0: 未删除 1: 已删除")
    private Boolean isDeleted;

    /**
     * 修改人
     */
    @Column(name = "modify_by")
    @ApiModelProperty("修改人")
    private Long modifyBy;

    /**
     * 修改时间
     */
    @Column(name = "modify_time")
    @ApiModelProperty("修改时间")
    private Date modifyTime;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    @ApiModelProperty("创建人")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_time")
    @ApiModelProperty("创建时间")
    private Date createTime;

    private static final long serialVersionUID = 1L;
}