package com.onsiteservice.entity.area;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import tk.mybatis.mapper.annotation.LogicDelete;

@Getter
@Setter
@ToString
@ApiModel("服务区域")
@Table(name = "service_area")
public class ServiceArea implements Serializable {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty("主键")
    private Long id;

    /**
     * 编码
     */
    @ApiModelProperty("编码")
    private String code;

    /**
     * 父编码
     */
    @Column(name = "parent_code")
    @ApiModelProperty("父编码")
    private String parentCode;

    /**
     * 名称
     */
    @ApiModelProperty("名称")
    private String name;

    /**
     * 名称路径
     */
    @Column(name = "name_path")
    @ApiModelProperty("名称路径")
    private String namePath;

    /**
     * 市区街道 city district street
     */
    @ApiModelProperty("市区街道 city district street")
    private String level;

    /**
     * 经度,纬度
     */
    @ApiModelProperty("经度,纬度")
    private String center;

    /**
     * 是否启用
     */
    @LogicDelete(notDeletedValue = 1, isDeletedValue = 0)
    @ApiModelProperty("是否启用")
    private Boolean enabled;

    /**
     * 修改时间
     */
    @Column(name = "modify_time")
    @ApiModelProperty("修改时间")
    private Date modifyTime;

    /**
     * 创建时间
     */
    @Column(name = "create_time")
    @ApiModelProperty("创建时间")
    private Date createTime;

    private static final long serialVersionUID = 1L;
}