package com.onsiteservice.core.exception;

import com.onsiteservice.constant.enums.BizCodeEnum;
import lombok.Getter;
import lombok.Setter;

/**
 * @author 潘维吉
 * @date 2018-05-19
 * 业务异常统一捕获处理 返回客户端 如 "账号或密码错误"
 * throw new ServiceException("账号或密码错误")，会直接被封装为 {"code":400,"msg":"账号或密码错误"} 返回
 */
@Getter
@Setter
public class ServiceException extends RuntimeException {

    /** 响应状态码枚举 */
    private Integer code;

    /** 是否要统一异常处理 */
    private Boolean isHandle = true;

    /** 是否要打印和存储日志 */
    private Boolean isLog = true;

    /**
     * 传入异常信息
     */
    public ServiceException(String message) {
        super(message);
    }

    public ServiceException(BizCodeEnum biz) {
        super(biz.getMsg());
    }

    /**
     * 自定义传入code状态码和异常信息
     */
    public ServiceException(Integer code, String message) {
        super(message);
        this.code = code;
    }

    /**
     * 传入异常信息 是否统一异常处理 否 不处理 用于上层捕获处理
     */
    public ServiceException(Boolean isHandle, String message) {
        super(message);
        this.isHandle = isHandle;
    }

    /**
     * 传入异常信息 是否要打印和存储日志到数据库
     */
    public ServiceException(String message, Boolean isLog) {
        super(message);
        this.isLog = isLog;
    }

    /**
     * cause表示起因对象
     */
    public ServiceException(String message, Throwable cause) {
        super(message, cause);
    }
}
