package com.onsiteservice.core.exception;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * @author 潘维吉
 * @date 2020/8/17 14:48
 * @email 406798106@qq.com
 * @description 自定义参数校验错误码和错误信息注解
 * 自定义异常码使用在属性是注解   @CustomExCode(code = 100002, msg = "系统繁忙") 配合@NotNull等验证注解使用
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.FIELD}) // 表明该注解只能放在类的字段上
public @interface CustomExCode {

    int code() default 400;     // 响应码code

    String msg() default "参数校验错误";    // 响应信息msg

}
