package com.onsiteservice.common.socket;

import com.alibaba.fastjson.JSON;
import lombok.*;
import org.springframework.web.socket.TextMessage;

/**
 * @author 潘维吉
 * @date 2018-08-27
 * WebSocket 消息返回结果集封装
 */
@NoArgsConstructor
@AllArgsConstructor
@Getter
@Setter
@ToString
public class SocketData<T> {

    private String key; //消息关键字key
    private T data; //消息的内容
    private String msg = "WebSocket服务端推送的消息"; //消息的说明

    public SocketData(String key, T data) {
        this.key = key;
        this.data = data;
    }

    public TextMessage toTextMessage(String key, T data) {
        return new TextMessage(JSON.toJSONString(new SocketData(key, data)));
    }

    public TextMessage toTextMessage(String key, T data, String msg) {
        return new TextMessage(JSON.toJSONString(new SocketData(key, data, msg)));
    }
}
