package com.onsiteservice.common.service;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.bean.WxMaSubscribeMessage;
import com.onsiteservice.core.exception.ServiceException;
import com.onsiteservice.dao.mapper.user.UserMapper;
import com.onsiteservice.entity.order.ServiceOrder;
import com.onsiteservice.entity.user.User;
import com.onsiteservice.service.order.WorkUser;
import lombok.extern.slf4j.Slf4j;
import me.chanjar.weixin.common.error.WxErrorException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * 小程序通知
 */
@Slf4j
@Service
public class MiniAppMessageService {

    @Resource
    private WxMaService wxMaService;
    @Resource
    private UserMapper userMapper;

    @Value("${wx.miniapp.message-template.pay}")
    private String payTmp;

    @Value("${wx.miniapp.message-template.valuator}")
    private String valuatorTmp;

    /**
     * 小程序发送订阅消息
     */
    public void sendSubscribeMsg(String templateId, String openId, List<WxMaSubscribeMessage.MsgData> data) {
        try {
            wxMaService.getMsgService().sendSubscribeMsg(WxMaSubscribeMessage.builder()
                    .templateId(templateId)
                    .data(data)
                    .toUser(openId)
                    .build());
        } catch (Exception e) {
            log.error("发送订阅消息异常:" + templateId, e);
            throw new ServiceException("发送订阅消息异常:" + templateId, e);
        }
    }

    /**
     * 提醒支付消息
     *
     * @param order 订单对象
     */
    @Async
    public void sendPay(ServiceOrder order) {
        var user = userMapper.selectByPrimaryKey(order.getAccountNo());
        // 计算剩余时间
        var left = order.getCancelTime().getTime() - System.currentTimeMillis();
        var leftStr = left / 60000 + "分" + (left / 1000) % 60 + "秒";
        List<WxMaSubscribeMessage.MsgData> data =
                List.of(
                        new WxMaSubscribeMessage.MsgData("character_string1", order.getOrderNo()),
                        new WxMaSubscribeMessage.MsgData("phrase4", "未支付"),
                        new WxMaSubscribeMessage.MsgData("thing2", order.getServiceName()),
                        new WxMaSubscribeMessage.MsgData("amount3", order.getPrice() + "元"),
                        new WxMaSubscribeMessage.MsgData("thing11", leftStr));
        sendSubscribeMsg(payTmp, user.getOpenId(), data);
    }

    @Async
    public void sendValuator(ServiceOrder order, String remark, User valuatorUser) {
        var user = userMapper.selectByPrimaryKey(order.getAccountNo());

        List<WxMaSubscribeMessage.MsgData> data =
                List.of(
                        new WxMaSubscribeMessage.MsgData("character_string1", order.getOrderNo()),
                        new WxMaSubscribeMessage.MsgData("thing7", order.getServiceName()),
                        new WxMaSubscribeMessage.MsgData("thing11", valuatorUser.getUserName()),
                        new WxMaSubscribeMessage.MsgData("phone_number16", valuatorUser.getPhone()),
                        new WxMaSubscribeMessage.MsgData("thing5", StringUtils.isEmpty(remark)? "-" : remark));
        sendSubscribeMsg(valuatorTmp, user.getOpenId(), data);
    }

}
