package com.onsiteservice.admin.service.sys;

import com.onsiteservice.admin.controller.sys.vo.LoginInitVO;
import com.onsiteservice.admin.controller.sys.vo.SysBusinessTree;
import com.onsiteservice.dao.common.AbstractMapper;
import com.onsiteservice.dao.mapper.sys.SysBusinessMapper;
import com.onsiteservice.dao.mapper.sys.SysBusinessOperateMapper;
import com.onsiteservice.dao.mapper.sys.SysUserMapper;
import com.onsiteservice.entity.sys.SysBusiness;
import com.onsiteservice.entity.sys.SysBusinessOperate;
import com.onsiteservice.entity.sys.SysUser;
import com.onsiteservice.entity.sys.vo.MenuTreeVO;
import com.onsiteservice.util.tree.TreePathUtils;
import com.onsiteservice.util.tree.TreeUtils;
import lombok.AllArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;
import java.util.stream.Collectors;


@Service
@Transactional(rollbackFor = Exception.class)
@AllArgsConstructor(onConstructor_ = {@Autowired})
public class SysBusinessService extends AbstractMapper<SysBusiness> {

    private SysUserMapper sysUserMapper;
    private SysBusinessMapper sysBusinessMapper;
    private SysBusinessOperateMapper sysBusinessOperateMapper;


    /**
     * 登录后初始化
     * 菜单、权限、用户信息等
     */
    public LoginInitVO init(Long userId) {
        LoginInitVO loginInitVO = new LoginInitVO();
        List<MenuTreeVO> businessList;

        SysUser user = sysUserMapper.selectByPrimaryKey(userId);
        loginInitVO.setUserInfo(user);

        if (Objects.nonNull(user)) {
            if (user.getIsGod()) {
                businessList = getAllBusiness();
                loginInitVO.setOperateList(getAllOperations().stream().map(SysBusinessOperate::getOperateKey).collect(Collectors.toList()));
            } else {
                businessList = getUserBusiness(userId);
                loginInitVO.setOperateList(getUserOperations(userId).stream().map(SysBusinessOperate::getOperateKey).collect(Collectors.toList()));
            }
        } else {
            businessList = List.of();
        }

        // 动态生成TreePath 这是是最复杂的场景 其他场景可以根据规范简化参数
        TreePathUtils.genPath(businessList, "code", "parentCode", "treePath", "/", "name");
        loginInitVO.setMenuList(TreeUtils.getTree(businessList, MenuTreeVO::getCode, MenuTreeVO::getParentCode, MenuTreeVO::setChildren));

        return loginInitVO;
    }

    public List<MenuTreeVO> getAllBusiness() {
        return sysBusinessMapper.getAllBusiness();
    }

    public List<MenuTreeVO> getUserBusiness(Long userId) {
        return sysBusinessMapper.getUserBusiness(userId);
    }

    public List<SysBusinessOperate> getUserOperations(Long userId) {
        return sysBusinessOperateMapper.getOperateByUserId(userId);
    }

    public List<SysBusinessOperate> getAllOperations() {
        return sysBusinessOperateMapper.selectAll();
    }


    /**
     * 获取全部业务数据
     * @return
     */
    public List<SysBusinessTree> getAllList() {
        List<SysBusiness> businessList = sysBusinessMapper.selectAll();
        List<SysBusinessTree> treeNodeList = businessList.stream().map(b -> new SysBusinessTree(b)).collect(Collectors.toList());
        return TreeUtils.getTree(treeNodeList, SysBusinessTree::getCode, SysBusinessTree::getParentCode, SysBusinessTree::setChildren);
    }

}
