package com.onsiteservice.admin.service.banner;

import com.onsiteservice.dao.util.EntityUtils;
import com.onsiteservice.entity.banner.Banner;
import com.onsiteservice.dao.mapper.banner.BannerMapper;
import com.onsiteservice.admin.mapper.banner.BannerBizMapper;

import com.onsiteservice.dao.common.AbstractMapper;
import com.onsiteservice.dao.common.page.PageParams;
import com.onsiteservice.dao.common.page.PageInfoVO;
import com.github.pagehelper.PageHelper;
import com.onsiteservice.util.aliyun.OssUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * @author 商天翔
 * @date 2022-07-12 14:37
 * @description BannerService服务类
 */
@Service
@Transactional(rollbackFor = Exception.class)
public class BannerService extends AbstractMapper<Banner> {

    @Resource
    private BannerMapper bannerMapper;
    @Resource
    private BannerBizMapper bannerBizMapper;
    @Resource
    private OssUtils ossUtils;

    /**
     * 分页查询列表
     */
    public List<Banner> getPage() {
        return bannerMapper.selectAll();
    }

    /**
     * 保存或更新方法
     */
    public int saveOrUpdate(Banner banner, Long userId) {
        if (banner.getId() == null) {
            EntityUtils.insert(banner, userId);
            return this.insertSelective(banner);
        } else {
            EntityUtils.update(banner, userId);
            return this.updateByPrimaryKeySelectiveForce(banner, List.of("mpArticle"));
        }
    }

    public int enable(Banner banner) {
        return bannerBizMapper.enable(banner);
    }

    public int deleteOne(Long id) {
        var banner = selectByPrimaryKey(id);
        if(StringUtils.isNotBlank(banner.getUrl())) {
            ossUtils.deleteFileAsync(banner.getUrl());
        }
        return bannerMapper.deleteByPrimaryKey(id);
    }
}
