package com.onsiteservice.admin.security.authentication;


import com.onsiteservice.admin.security.SecurityService;
import com.onsiteservice.admin.security.pojo.CustomUserDetails;
import com.onsiteservice.util.ReflectUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.security.authentication.AuthenticationCredentialsNotFoundException;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;

import javax.annotation.Resource;
import java.util.ArrayList;

/**
 * @author 潘维吉
 * @date 2020/3/5 13:57
 * @email 406798106@qq.com
 * @description 自定义用户详情服务实现
 */

@Slf4j
public class CustomUserDetailsService implements UserDetailsService {

    @Resource
    private SecurityService securityService;

    /**
     * 提供一种从用户名可以查到用户并返回的方法 每次登陆调用
     * 用户名attemptAuthentication方法传入
     */
    @Override
    public UserDetails loadUserByUsername(String userName) {
        log.info("2. CustomUserDetailsService.loadUserByUsername");
        Object user = securityService.getUserByName(userName);
        // 出现异常会在unsuccessfulAuthentication方法处理响应数据
        if (ObjectUtils.isEmpty(user)) {
            throw new AuthenticationCredentialsNotFoundException("用户名不存在");
        }
        if (!(Boolean) ReflectUtils.invokeGetter(user, CustomUserDetails.IS_ENABLED)) {
            throw new DisabledException("账号已被禁用");
        }
        return new CustomUserDetails(user, new ArrayList<>());
    }
}
