package com.onsiteservice.admin.controller.sys;

import com.github.pagehelper.PageHelper;
import com.onsiteservice.admin.service.sys.SysBusinessOperateResourceService;
import com.onsiteservice.core.result.Result;
import com.onsiteservice.core.result.ResultGenerator;
import com.onsiteservice.dao.common.page.PageInfoVO;
import com.onsiteservice.dao.common.page.PageParams;
import com.onsiteservice.entity.sys.SysBusinessOperateResource;
import lombok.NonNull;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.validation.constraints.Positive;
import java.util.List;

/**
 * @author wangning
 * @date 2019-10-11 09:02
 * SysBusinessOperateResourceController控制类
 */
@RestController
@RequestMapping("/sys/business/operate/resource")
@Validated
public class SysBusinessOperateResourceController {

    @Resource
    private SysBusinessOperateResourceService sysBusinessOperateResourceService;

    /**
     * 分页查询列表
     *
     * @param page 分页参数
     * @return 分页数据
     */
    @GetMapping("/list")
    public Result pageList(@Validated PageParams page) {
        PageHelper.startPage(page.getPage(), page.getSize());
        List<SysBusinessOperateResource> list = sysBusinessOperateResourceService.selectAll();
        PageInfoVO pageInfo = new PageInfoVO(list);
        return ResultGenerator.success(pageInfo, "获取分页列表");
    }

    /**
     * 根据id查询
     *
     * @param id 主键
     * @return 详情数据
     */
    @GetMapping("/{id}")
    public Result findById(@PathVariable @Positive Integer id) {
        SysBusinessOperateResource sysBusinessOperateResource = sysBusinessOperateResourceService.selectByPrimaryKey(id);
        return ResultGenerator.success(sysBusinessOperateResource, "根据id获取详情");
    }

    /**
     * 新增保存对象
     *
     * @param sysBusinessOperateResource 保存对象
     */
    @PostMapping
    public Result save(@RequestBody @NonNull @Validated SysBusinessOperateResource sysBusinessOperateResource) {
        sysBusinessOperateResourceService.insertSelective(sysBusinessOperateResource);
        return ResultGenerator.success(sysBusinessOperateResource, "新增成功");
    }

    /**
     * 更新修改对象
     *
     * @param sysBusinessOperateResource 修改对象
     */
    @PutMapping
    public Result update(@RequestBody @NonNull @Validated SysBusinessOperateResource sysBusinessOperateResource) {
        sysBusinessOperateResourceService.updateByPrimaryKeySelective(sysBusinessOperateResource);
        return ResultGenerator.success(sysBusinessOperateResource, "更新成功");
    }

    /**
     * 根据id删除
     *
     * @param id 主键
     */
    @DeleteMapping("/{id}")
    public Result deleteById(@PathVariable @Positive Integer id) {
        sysBusinessOperateResourceService.deleteByPrimaryKey(id);
        return ResultGenerator.success("删除成功");
    }

    @GetMapping("/getByOperate/{id}")
    public Result getByOperateId(@PathVariable @Positive Long id) {
        return ResultGenerator.success(sysBusinessOperateResourceService.getByOperateId(id), "查询成功");
    }

    @PostMapping("/batchDelete")
    public Result batchDelete(@RequestBody List<Long> ids) {
        sysBusinessOperateResourceService.deleteBatch(ids);
        return ResultGenerator.success(true, "删除成功");
    }


}
