<#if isGenFileModule >
package ${currentPackage}.controller.${fileModule};

import ${entityPackage}.${fileModule}.${modelNameUpperCamel};
import ${currentPackage}.service.${fileModule}.${modelNameUpperCamel}Service;
<#else>
package ${currentPackage}.controller;

import ${entityPackage}.${modelNameUpperCamel};
import ${currentPackage}.service.${modelNameUpperCamel}Service;
</#if>

import ${corePackage}.result.Result;
import ${commonDaoPackage}.common.page.PageParams;
import lombok.NonNull;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.validation.constraints.Positive;

import static ${corePackage}.result.ResultGenerator.success;
import static ${corePackage}.result.ResultGenerator.fail;

/**
 * @author ${author}
 * @date ${date}
 * @description ${modelNameUpperCamel}Controller控制类
 */
@RestController
@RequestMapping("${requestMappingPath}")
@Validated
public class ${modelNameUpperCamel}Controller {

    @Resource
    private ${modelNameUpperCamel}Service ${modelNameLowerCamel}Service;

    /**
     * 分页查询列表
     *
     * @param param 分页参数
     * @return 分页数据
     */
    @PostMapping("/page")
    public Result getPage(@RequestBody @NonNull @Validated PageParams param) {
        return success(${modelNameLowerCamel}Service.getPage(param), "获取分页列表");
    }

    /**
     * 根据id查询
     *
     * @param id 主键
     * @return 详情数据
     */
    @GetMapping("/{id}")
    public Result getDetails(@PathVariable @Positive Long id) {
        return success(${modelNameLowerCamel}Service.selectByPrimaryKey(id), "根据id获取详情");
    }

<#if isGenSaveOrUpdate >
    /**
     * 新增或修改
     */
    @PostMapping("/save-or-update")
    public Result saveOrUpdate(@RequestBody @NonNull @Validated ${modelNameUpperCamel} ${modelNameLowerCamel}) {
        return success(${modelNameLowerCamel}Service.saveOrUpdate(${modelNameLowerCamel}),  ${modelNameLowerCamel}.getId() == null ? "新增成功" : "修改成功");
    }
<#else>
    /**
     * 新增
     *
     * @param ${modelNameLowerCamel} 新增对象
     */
    @PostMapping
    public Result save(@RequestBody @NonNull @Validated ${modelNameUpperCamel} ${modelNameLowerCamel}) {
        return success(${modelNameLowerCamel}Service.insertSelective(${modelNameLowerCamel}), "新增成功");
    }

    /**
     * 修改
     *
     * @param ${modelNameLowerCamel} 修改对象
     */
    @PutMapping
    public Result update(@RequestBody @NonNull @Validated ${modelNameUpperCamel} ${modelNameLowerCamel}) {
        return success(${modelNameLowerCamel}Service.updateByPrimaryKeySelective(${modelNameLowerCamel}), "修改成功");
    }
</#if>

    /**
     * 根据id删除
     *
     * @param id 主键
     */
    @DeleteMapping("/{id}")
    public Result deleteById(@PathVariable @Positive Long id) {
        return success(${modelNameLowerCamel}Service.deleteByPrimaryKey(id), "删除成功");
    }

}
