package com.onsiteservice.miniapp.service.area;

import com.onsiteservice.entity.area.ServiceArea;
import com.onsiteservice.dao.mapper.service.ServiceAreaMapper;

import com.onsiteservice.dao.common.AbstractMapper;
import com.onsiteservice.dao.common.page.PageParams;
import com.onsiteservice.dao.common.page.PageInfoVO;
import com.github.pagehelper.PageHelper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;

/**
 * @author 潘维吉
 * @date 2022-07-08 09:11
 * @description ServiceAreaService服务类
 */
@Service
@Transactional(rollbackFor = Exception.class)
public class ServiceAreaService extends AbstractMapper<ServiceArea> {

    @Resource
    private ServiceAreaMapper serviceAreaMapper;

    /**
     * 分页查询列表
     */
    public PageInfoVO getPage(PageParams param) {
        PageHelper.startPage(param.getPage(), param.getSize());
        return new PageInfoVO(this.selectAll());
    }

    /**
     * 保存或更新方法
     */
    public int saveOrUpdate(ServiceArea serviceArea) {
        if (serviceArea.getId() == null) {
            return this.insertSelective(serviceArea);
        } else {
            return this.updateByPrimaryKeySelective(serviceArea);
        }
    }
}
