package com.onsiteservice.miniapp.controller.weixn.dto;


import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import javax.validation.constraints.NotBlank;

/**
 * @author 潘维吉
 * @date 2019-3-20 13:36
 * 微信登录参数
 * DTO 数据传输对象类 Bean是跟数据库有关的实体类，而DTO是与数据库无关的数据，只是为了数据显示时创建的中间层用于数据展示的
 * DTO通常用于不同层（UI层、服务层或者域模型层）直接的数据传输，以隔离不同层，降低层间耦合
 * DTO类来继承entity实体类，在DTO类里放一些业务字段，并提供get、set方法
 * 当我们在业务逻辑层或者交互层用到一些数据库中不存在的字段时，我们就需要在DTO类里放这些字段
 * 这些字段的意义就相当于一些经处理过的数据库字段，实质意义就是方便数据交互，提高效率
 */
@ApiModel("微信登录参数")
@Getter
@Setter
@ToString
public class LoginDTO {

    @ApiModelProperty(value = "微信登录code", required = true)
    @NotBlank(message = "微信code不能为空")
    private String code;

/*  @ApiModelProperty(value = "微信登录用户信息")
    @NotNull(message = "用户信息userInfo不能为null")
    private Map userInfo;*/

    @ApiModelProperty(value = "服务端获取数据 不可泄露给前端 存在风险", hidden = true)
    private String sessionKey;

    private String encryptedData;

    private String iv;

    private String signature;

    private String rawData;

    @ApiModelProperty("分享者用户id")
    private Long shareUserId;
}
