package com.onsiteservice.miniapp.controller.category;

import com.onsiteservice.common.annotation.user.CurrentUserId;
import com.onsiteservice.core.result.Result;
import com.onsiteservice.miniapp.controller.category.vo.HomeViewVO;
import com.onsiteservice.miniapp.service.category.HomeCommonService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * <P>服务大类模块</P>
 *
 * @author 李宁
 * @version v1.0
 * @since 2022/7/7 08:51
 */
@Api(tags = "首页模块")
@RestController
@RequestMapping("/common/")
@Validated
public class HomeCommonController {


    @Resource
    private HomeCommonService homeCommonService;


    @ApiOperation(value = "首页")
    @GetMapping("home")
    public Result<HomeViewVO> home(@CurrentUserId Long userId) {
        return homeCommonService.home(userId);
    }

    @ApiOperation(value = "地域树")
    @GetMapping("tree")
    public Result tree() {
        return homeCommonService.tree();
    }


}
