package com.onsiteservice.entity.sys;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

@Getter
@Setter
@ToString
@ApiModel("角色操作表")
@Table(name = "sys_role_operate")
public class SysRoleOperate implements Serializable {
    /**
     * 主键
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty("主键")
    private Long id;

    /**
     * 关联角色
     */
    @Column(name = "role_id")
    @ApiModelProperty("关联角色")
    private Long roleId;

    /**
     * 关联业务操作
     */
    @Column(name = "business_operate_id")
    @ApiModelProperty("关联业务操作")
    private Long businessOperateId;

    /**
     * 创建时间
     */
    @Column(name = "create_time")
    @ApiModelProperty("创建时间")
    private Date createTime;

    private static final long serialVersionUID = 1L;
}