package com.onsiteservice.entity.sys;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

@Getter
@Setter
@ToString
@ApiModel("系统字典表")
@Table(name = "sys_dict")
public class SysDict implements Serializable {
    /**
     * 主键
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty("主键")
    private Long id;

    /**
     * 类型编号
     */
    @Column(name = "type_code")
    @ApiModelProperty("类型编号")
    private String typeCode;

    /**
     * 字典码
     */
    @ApiModelProperty("字典码")
    private String code;

    /**
     * 字典值
     */
    @ApiModelProperty("字典值")
    private String value;

    /**
     * 扩展值
     */
    @Column(name = "extend_value")
    @ApiModelProperty("扩展值")
    private String extendValue;

    /**
     * 备注
     */
    @ApiModelProperty("备注")
    private String remark;

    /**
     * 显示排序号 数字越小优先级越高
     */
    @Column(name = "show_order")
    @ApiModelProperty("显示排序号 数字越小优先级越高")
    private Integer showOrder;

    /**
     * 是否启用 0: 禁用 1: 启用
     */
    @Column(name = "is_enabled")
    @ApiModelProperty("是否启用 0: 禁用 1: 启用")
    private Boolean isEnabled;

    /**
     * 修改人
     */
    @Column(name = "modify_by")
    @ApiModelProperty("修改人")
    private Long modifyBy;

    /**
     * 修改时间
     */
    @Column(name = "modify_time")
    @ApiModelProperty("修改时间")
    private Date modifyTime;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    @ApiModelProperty("创建人")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_time")
    @ApiModelProperty("创建时间")
    private Date createTime;

    private static final long serialVersionUID = 1L;
}