package com.onsiteservice.entity.home;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import tk.mybatis.mapper.annotation.LogicDelete;

@Getter
@Setter
@ToString
@ApiModel("首页通知")
@Table(name = "home_notice")
public class HomeNotice implements Serializable {
    /**
     * 主键
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty("主键")
    private Long id;

    /**
     * 标题
     */
    @ApiModelProperty("标题")
    private String title;

    /**
     * 摘要
     */
    @ApiModelProperty("摘要")
    private String content;

    /**
     * 发布状态 1.新建 2.已发布 3.已撤销
     */
    @Column(name = "release_status")
    @ApiModelProperty("发布状态 1.新建 2.已发布 3.已撤销")
    private Integer releaseStatus;

    /**
     * 显示排序号 数字越大优先级越高
     */
    @Column(name = "show_order")
    @ApiModelProperty("显示排序号 数字越大优先级越高")
    private Integer showOrder;

    /**
     * 是否删除 0.未删除 1.已删除
     */
    @LogicDelete
    @ApiModelProperty("是否删除 0.未删除 1.已删除")
    private Boolean deleted;

    /**
     * 修改人
     */
    @Column(name = "modify_by")
    @ApiModelProperty("修改人")
    private Long modifyBy;

    /**
     * 修改时间
     */
    @Column(name = "modify_time")
    @ApiModelProperty("修改时间")
    private Date modifyTime;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    @ApiModelProperty("创建人")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_time")
    @ApiModelProperty("创建时间")
    private Date createTime;

    private static final long serialVersionUID = 1L;
}