package com.onsiteservice.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author 潘维吉
 * @date 2020/4/21 15:32
 * @email 406798106@qq.com
 * @description 正则验证和常量工具类
 */
public class RegexUtils {
    /**
     * 正则统一常量定义
     */
    public static final String PHONE = "^1\\d{10}$";
    public static final String NUM = "^[0-9]*$";

    /**
     * 验证字符串是否符合表达式
     *
     * @param regex 正则表达式
     * @param value 待匹配值
     * @return
     * @throws
     * @author liub
     */
    public static boolean isMatch(String regex, String value) {
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(value);
        return m.matches();
    }
}
