package com.onsiteservice.common.controller.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

/**
 * @author 潘维吉
 * @date 2020/1/15 15:41
 * @email 406798106@qq.com
 * @description 令牌VO
 */
@ApiModel(description = "Token接口响应数据")
@Builder
@Getter
@Setter
@ToString
public class TokenVO {

    /**
     * 令牌Token
     */
    @ApiModelProperty("令牌Token")
    private String token;

    /**
     * Token过期时间
     */
    @ApiModelProperty(value = "Token过期时间(秒)", example = "-1")
    private Long expiresTime;

}
