package com.onsiteservice.common.annotation.dict;

import java.lang.annotation.*;

/**
 * @author 潘维吉
 * @date 2020/3/13 16:56
 * @email 406798106@qq.com
 * @description 字典翻译注解
 * 在Controller方法使用
 * 单字典值翻译 @Dict(code = "SYS0001", name = "status") 翻译结果可以为 平级 {status: 1 , statusValue: "启用"} 或 层级 {status: {code: 0 , value: "禁用"}}
 * 多字典值翻译 @Dict(code = {"SYS0001","SYS0002"}, name = {"status","sex"})
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.METHOD})
@Documented
public @interface Dict {

    String[] code(); // 主表编码

    String[] name(); // 属性名 不是数据库字段名 map类型为key
}
