package com.onsiteservice.admin.service.sys;

import com.github.pagehelper.PageHelper;
import com.onsiteservice.dao.common.AbstractMapper;
import com.onsiteservice.dao.common.page.PageInfoVO;
import com.onsiteservice.dao.common.page.PageParams;
import com.onsiteservice.dao.mapper.sys.SysRoleOperateMapper;
import com.onsiteservice.entity.sys.SysRoleOperate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * SysRoleOperateService服务类
 */
@Service
@Transactional(rollbackFor = Exception.class)
public class SysRoleOperateService extends AbstractMapper<SysRoleOperate> {

    @Resource
    private SysRoleOperateMapper sysRoleOperateMapper;

    /**
     * 分页查询列表
     */
    public PageInfoVO getPage(PageParams param) {
        PageHelper.startPage(param.getPage(), param.getSize());
        return new PageInfoVO(this.selectAll());
    }

    /**
     * 保存或更新方法
     */
    public int saveOrUpdate(SysRoleOperate sysRoleOperate) {
        if (sysRoleOperate.getId() == null) {
            return this.insertSelective(sysRoleOperate);
        } else {
            return this.updateByPrimaryKeySelective(sysRoleOperate);
        }
    }

    public void delByOperates(List<Long> ids) {
        sysRoleOperateMapper.deleteByIdList(ids);
    }
}
