package com.onsiteservice.admin.service.sys;

import com.onsiteservice.dao.common.AbstractMapper;
import com.onsiteservice.dao.mapper.sys.SysBusinessOperateResourceMapper;
import com.onsiteservice.entity.sys.SysBusinessOperateResource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Condition;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author wang jianguo
 * @date 2021-07-21 10:11
 * SysBusinessOperateResourceService服务类
 */
@Service
@Transactional(rollbackFor = Exception.class)
public class SysBusinessOperateResourceService extends AbstractMapper<SysBusinessOperateResource> {

    @Resource
    private SysBusinessOperateResourceMapper sysBusinessOperateResourceMapper;

    public void delByOperates(List<Long> ids) {
        Condition condition = new Condition(SysBusinessOperateResource.class);
        condition.createCriteria().andIn("businessOperateId", ids);
        sysBusinessOperateResourceMapper.deleteByCondition(condition);
    }

    public List<SysBusinessOperateResource> getByOperateId(Long id) {
        Condition condition = new Condition(SysBusinessOperateResource.class);
        condition.createCriteria().andEqualTo("businessOperateId", id);
        return sysBusinessOperateResourceMapper.selectByCondition(condition);
    }

    public void deleteBatch(List<Long> ids) {
        sysBusinessOperateResourceMapper.deleteByIdList(ids);
    }
}
