package com.onsiteservice.admin.controller.sys.vo;

import com.onsiteservice.entity.sys.SysBusiness;
import com.onsiteservice.entity.sys.SysBusinessOperate;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * 业务树VO
 */
@Data
public class SysBusinessTree {

    public SysBusinessTree() {
    }

    public SysBusinessTree(SysBusiness sysBusiness) {
        this.id = sysBusiness.getId();
        this.code = sysBusiness.getCode();
        this.name = sysBusiness.getName();
        this.parentCode = sysBusiness.getParentCode();
        this.icon = sysBusiness.getIcon();
        this.vrPath = sysBusiness.getVrPath();
        this.vrName = sysBusiness.getVrName();
        this.vrRedirect = sysBusiness.getVrRedirect();
        this.vrComponentPath = sysBusiness.getVrComponentPath();
        this.vrKeepAlive = sysBusiness.getIsCache();
        this.showInMenu = sysBusiness.getIsShow();
        this.showOrder = sysBusiness.getShowOrder();
        this.ctDate = sysBusiness.getCreateTime();
    }

    private Long id;
    private String code;
    private String name;
    private String parentName;
    private String parentCode;
    private String icon;
    private String vrPath;
    private String vrName;
    private String vrRedirect;
    private String vrComponentPath;
    private Boolean vrKeepAlive;
    private Boolean showInMenu;
    private Integer showOrder;
    private Date ctDate;

    private List<SysBusinessTree> children;

    private List<SysBusinessOperate> sysBusinessOperateList;


}
