package com.onsiteservice.miniapp.service.category;

import com.google.common.collect.Lists;
import com.onsiteservice.core.result.Result;
import com.onsiteservice.core.result.ResultGenerator;
import com.onsiteservice.dao.common.AbstractMapper;
import com.onsiteservice.dao.mapper.service.ServiceCategoryMapper;
import com.onsiteservice.dao.mapper.service.ServiceSubclassMapper;
import com.onsiteservice.entity.category.ServiceCategory;
import com.onsiteservice.entity.category.ServiceSubclass;
import com.onsiteservice.miniapp.controller.category.vo.ServiceCategoryVO;
import com.onsiteservice.miniapp.controller.category.vo.ServiceSubclassVO;
import com.onsiteservice.util.AttrCopyUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service
@Transactional(rollbackFor = Exception.class)
public class ServiceCategoryService extends AbstractMapper<ServiceCategory> {

    //@Resource
    //private ServiceCategoryBizMapper serviceCategoryBizMapper;

    @Resource
    private ServiceCategoryMapper serviceCategoryMapper;
    @Resource
    private ServiceSubclassMapper serviceSubclassMapper;


    public Result<List<ServiceCategoryVO>> list(String keyWord) {
        List<ServiceCategory> serviceCategoryList = serviceCategoryMapper.selectAllOrderBySequence();

        List<ServiceSubclass> serviceSubclassList = serviceSubclassMapper.selectByServiceNameLike(keyWord);
        Map<Integer, List<ServiceSubclass>> categoryIdServiceSubclassMap = serviceSubclassList.parallelStream().collect(Collectors.groupingBy(ServiceSubclass::getCategoryId));

        List<ServiceCategoryVO> serviceCategoryVOList = serviceCategoryList.parallelStream().map(e -> {
            ServiceCategoryVO serviceCategoryVO = AttrCopyUtils.copy(e, new ServiceCategoryVO());

            List<ServiceSubclass> childServiceSubclassList = categoryIdServiceSubclassMap.getOrDefault(serviceCategoryVO.getId(), Lists.newArrayList());
            List<ServiceSubclassVO> childServiceSubclassVOList = childServiceSubclassList.parallelStream().map(e1 -> AttrCopyUtils.copy(e1, new ServiceSubclassVO())).collect(Collectors.toList());
            serviceCategoryVO.setChildren(childServiceSubclassVOList);

            return serviceCategoryVO;
        }).collect(Collectors.toList());

        return ResultGenerator.success(serviceCategoryVOList);
    }

    public Result<List<ServiceSubclassVO>> selectByKeyWord(String keyWord) {
        List<ServiceSubclass> serviceSubclassList = serviceSubclassMapper.selectByServiceNameLike(keyWord);
        List<ServiceSubclassVO> serviceSubclassVOList = serviceSubclassList.parallelStream()
                .map(e1 -> AttrCopyUtils.copy(e1, new ServiceSubclassVO())).collect(Collectors.toList());
        return ResultGenerator.success(serviceSubclassVOList);
    }


}
