package com.onsiteservice.miniapp.controller.weixn.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import javax.validation.constraints.NotBlank;

/**
 * @author 潘维吉
 * @date 2019-3-20 13:36
 * 微信解密参数
 */
@ApiModel(description = "微信解密参数")
@Getter
@Setter
@ToString
public class WxEncryptDTO {

    @ApiModelProperty(value = "微信登录code")
    @NotBlank(message = "微信code不能为空")
    private String code;

    @ApiModelProperty(value = "服务端数据 不可泄露给前端 存在风险", hidden = true)
    private String sessionKey;

    private String encryptedData;

    private String iv;
}
