package com.onsiteservice.miniapp.controller.category;

import com.onsiteservice.core.result.Result;
import com.onsiteservice.dao.common.page.PageInfoVO;
import com.onsiteservice.miniapp.controller.category.dto.PageServiceSubclassDTO;
import com.onsiteservice.miniapp.controller.category.vo.ServiceSubclassVO;
import com.onsiteservice.miniapp.service.category.ServiceSubclassService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.validation.constraints.Positive;

/**
 * <P>服务大类模块</P>
 *
 * @author 李宁
 * @version v1.0
 * @since 2022/7/7 08:51
 */
@Api(tags = "服务子类模块")
@RestController
@RequestMapping("/subclass/")
@Validated
public class ServiceSubclassController {


    @Resource
    private ServiceSubclassService serviceSubclassService;


    @ApiOperation(value = "根据id查询服务详情")
    @GetMapping("get/{id}")
    public Result<ServiceSubclassVO> getDetail(@ApiParam(name = "id", value = "服务子类id") @PathVariable @Positive Long id) {
        return serviceSubclassService.getDetail(id);
    }

}
