package com.onsiteservice.entity.sys;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

@Getter
@Setter
@ToString
@ApiModel("系统字典类型表")
@Table(name = "sys_dict_type")
public class SysDictType implements Serializable {
    /**
     * 主键
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty("主键")
    private Long id;

    /**
     * 类型 1: 系统默认 2: 自定义
     */
    @ApiModelProperty("类型 1: 系统默认 2: 自定义")
    private Integer type;

    /**
     * 编号
     */
    @ApiModelProperty("编号")
    private String code;

    /**
     * 类型值
     */
    @ApiModelProperty("类型值")
    private String value;

    /**
     * 备注
     */
    @ApiModelProperty("备注")
    private String remark;

    /**
     * 显示排序号 数字越小优先级越高
     */
    @Column(name = "show_order")
    @ApiModelProperty("显示排序号 数字越小优先级越高")
    private Integer showOrder;

    /**
     * 修改人
     */
    @Column(name = "modify_by")
    @ApiModelProperty("修改人")
    private Long modifyBy;

    /**
     * 修改时间
     */
    @Column(name = "modify_time")
    @ApiModelProperty("修改时间")
    private Date modifyTime;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    @ApiModelProperty("创建人")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_time")
    @ApiModelProperty("创建时间")
    private Date createTime;

    private static final long serialVersionUID = 1L;
}