package com.onsiteservice.entity.sys;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

@Getter
@Setter
@ToString
@ApiModel("系统业务操作资源表")
@Table(name = "sys_business_operate_resource")
public class SysBusinessOperateResource implements Serializable {
    /**
     * 主键
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty("主键")
    private Long id;

    /**
     * 业务操作id
     */
    @Column(name = "business_operate_id")
    @ApiModelProperty("业务操作id")
    private Long businessOperateId;

    /**
     * 操作路径
     */
    @Column(name = "operate_path")
    @ApiModelProperty("操作路径")
    private String operatePath;

    /**
     * url的请求方法 类型: GET POST PUT DELETE ALL
     */
    @Column(name = "operate_method")
    @ApiModelProperty("url的请求方法 类型: GET POST PUT DELETE ALL")
    private String operateMethod;

    /**
     * 修改人
     */
    @Column(name = "modify_by")
    @ApiModelProperty("修改人")
    private Long modifyBy;

    /**
     * 修改时间
     */
    @Column(name = "modify_time")
    @ApiModelProperty("修改时间")
    private Date modifyTime;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    @ApiModelProperty("创建人")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_time")
    @ApiModelProperty("创建时间")
    private Date createTime;

    private static final long serialVersionUID = 1L;
}