package com.onsiteservice.entity.base;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

@NoArgsConstructor
@AllArgsConstructor
@Builder
@Getter
@Setter
@ToString
@ApiModel("区域表")
@Table(name = "base_area")
public class BaseArea implements Serializable {
    /**
     * 主键id
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty("主键id")
    private Long id;

    /**
     * 父级code
     */
    @Column(name = "parent_code")
    @ApiModelProperty("父级code")
    private String parentCode;

    /**
     * 编码
     */
    @ApiModelProperty("编码")
    private String code;

    /**
     * 名称
     */
    @ApiModelProperty("名称")
    private String name;

    /**
     * 名称路径
     */
    @Column(name = "name_path")
    @ApiModelProperty("名称路径")
    private String namePath;

    /**
     * 等级 国家 省 市 区/县
     */
    @ApiModelProperty("等级 国家 省 市 区/县")
    private String level;

    /**
     * 经度,纬度
     */
    @ApiModelProperty("经度,纬度")
    private String center;

    /**
     * 显示排序号 数字越小优先级越高
     */
    @Column(name = "show_order")
    @ApiModelProperty("显示排序号 数字越小优先级越高")
    private Integer showOrder;

    /**
     * 修改时间
     */
    @Column(name = "modify_time")
    @ApiModelProperty("修改时间")
    private Date modifyTime;

    /**
     * 创建时间
     */
    @Column(name = "create_time")
    @ApiModelProperty("创建时间")
    private Date createTime;

    private static final long serialVersionUID = 1L;
}