package com.onsiteservice.dao.common.extra;


import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.Options;
import tk.mybatis.mapper.annotation.RegisterMapper;

import java.util.List;

/**
 * @author 潘维吉
 * @date 2019/10/21 8:49
 * @email 406798106@qq.com
 * @description 自定义批量插入通用Mapper接口 null值不会被插入
 */
@RegisterMapper
public interface InsertListSelectiveMapper<T> {

    /**
     * 批量插入，支持批量插入的数据库可以使用，例如MySQL,H2等，另外该接口限制实体包含`id`属性并且必须为自增列
     * 如果插入集合里面的实体中的属性值为null，则使用数据库的默认值
     * 避免数据列设置了非空约束时，插入数据失败！
     *
     * @param recordList
     */
    @Options(useGeneratedKeys = true)
    @InsertProvider(type = InsertListSelectiveProvider.class, method = "dynamicSQL")
    int insertListSelective(List<? extends T> recordList);
}
