package com.onsiteservice.core.security.xss;

import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;

import javax.servlet.*;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import java.io.IOException;

/**
 * @author 潘维吉
 * @date 2018-12-23 9:55
 * 使用注解标注过滤器 @ServletComponentScan入口文件启动或配置@Configuration的@WebFilter扫描才能生效
 * 注解@WebFilter将一个实现了javax.servlet.Filter接口的类定义为过滤器 属性filterName声明过滤器的名称, 可选
 * 属性urlPatterns指定要过滤 的URL模式,也可使用属性value来声明.(指定要过滤的URL模式是必选属性)
 * 属性 asyncSupported = true支持异步  适配WebFlux响应式编程
 */
@ConditionalOnProperty(prefix = "project.xss", name = {"enabled"}, matchIfMissing = false)
@Configuration
@WebFilter(filterName = "xssFilter", urlPatterns = "/*", asyncSupported = true)
public class XssFilter implements Filter {

    FilterConfig filterConfig = null;

    /**
     * 过滤器初始化
     *
     * @param config
     */
    @Override
    public void init(FilterConfig config) {
        this.filterConfig = config;
    }

    /**
     * 执行过滤操作
     *
     * @param request
     * @param response
     * @param filterChain
     * @throws IOException
     * @throws ServletException
     */
    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain)
            throws IOException, ServletException {
        filterChain.doFilter(new XssHandler((HttpServletRequest) request), response);
    }

    /**
     * 过滤器销毁
     */
    @Override
    public void destroy() {
        this.filterConfig = null;
    }

}
