package com.onsiteservice.constant.enums.convert;

import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.format.FormatterRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

import javax.annotation.Resource;

/**
 * @author 潘维吉
 * @date 2019-01-04 16:13
 * MVC统一配置类
 * 用于接受的枚举类转换绑定等
 */
@ConditionalOnProperty(prefix = "project.enum", name = {"enabled"}, matchIfMissing = true)
@Configuration
public class EnumConfig implements WebMvcConfigurer {

    /** 统一枚举类型转换绑定工厂类 */
    @Resource
    private EnumConverterFactory enumConverterFactory;

    /**
     * 通过覆盖addFormatter方法来实现对Converter和ConverterFactory的绑定
     *
     * @param registry
     */
    @Override
    public void addFormatters(FormatterRegistry registry) {
        registry.addConverterFactory(enumConverterFactory);
    }


}
