package com.onsiteservice.constant.constant;

/**
 * 项目核心常量 与业务无关
 */
public final class Constants {

    /**
     * http请求统一前缀
     */
    public static final String REQUEST_PREFIX = "";

    /**
     * 项目通用包名组
     */
    public static final String PACKAGE_NAME_GROUP = "com.onsiteservice";

    /**
     * 当前登录用户id的字段名
     */
    public static final String CURRENT_USER_ID = "CURRENT_USER_ID";

    /**
     * 当前登录用户平台类型的字段名
     */
    public static final String CURRENT_PLATFORM_TYPE = "CURRENT_PLATFORM_TYPE";
    /**
     * 当前登录用户平台id的字段名
     */
    public static final String CURRENT_PLATFORM_ID = "CURRENT_PLATFORM_ID";
    /**
     * 当前登录用户公司id的字段名
     */
    public static final String CURRENT_COMPANY_ID = "CURRENT_COMPANY_ID";

    /**
     * 当前WEBSOCKET用户id的字段名
     */
    public static final String WEBSOCKET_USER_ID = "WEBSOCKET_USER_ID";

    /**
     * ANSI escape code 用于日志打印颜色 提高可读性
     */
    public static final String ANSI_RESET = "\u001B[0m";
    public static final String ANSI_BLACK = "\u001B[30m";
    public static final String ANSI_RED = "\u001B[31m";
    public static final String ANSI_GREEN = "\u001B[32m";
    public static final String ANSI_LIGHT_YELLOW = "\u001B[93m";
    public static final String ANSI_YELLOW = "\u001B[33m";
    public static final String ANSI_YELLOW_BACKGROUND = "\u001B[43m";
    public static final String ANSI_BLUE = "\u001B[34m";
    public static final String ANSI_PURPLE = "\u001B[35m";
    public static final String ANSI_CYAN = "\u001B[36m";
    public static final String ANSI_WHITE = "\u001B[37m";
    public static final String ANSI_BOLD = "\u001B[1m";
    public static final String ANSI_UNBOLD = "\u001B[21m";
    public static final String ANSI_UNDERLINE = "\u001B[4m";
    public static final String ANSI_STOP_UNDERLINE = "\u001B[24m";
    public static final String ANSI_BLINK = "\u001B[5m";
}
