package com.onsiteservice.common.runner;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

import java.io.File;
import java.io.IOException;

/**
 * @author 潘维吉
 * @date 2019-10-14 14:10
 * Spring Boot启动执行
 * 该接口的方法会在服务启动之后被立即执行
 * 主要用来做一些初始化的工作
 * 该方法的运行是在SpringApplication.run() 执行完毕之前执行
 */
@Component
@Order(1)
@Slf4j
public class CommonRunner implements CommandLineRunner {

    @Value("${spring.profiles.active:dev}")
    private String env;

    /**
     * 会在服务启动完成后立即执行
     */
    @Override
    public void run(String... args) {
        if ("dev".equals(env)) {
            // Git提交信息规范强制限制
            String projectPath = System.getProperty("user.dir") + "\\";
            String fileName = "prepare-commit-msg";
            // FileUtils.deleteQuietly(new File(projectPath + ".git\\hooks\\"+fileName));
            try {
                FileUtils.copyFile(
                        new File(projectPath + fileName),
                        new File(projectPath + ".git\\hooks\\" + fileName));
            } catch (IOException e) {
                // e.printStackTrace();
            }
        }
    }
}
