package com.onsiteservice.common.order.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Positive;
import java.math.BigDecimal;

/**
 * <P></P>
 *
 * @author 李宁
 * @version v1.0
 * @since 2022/7/7 15:20
 */
@Data
@ApiModel("发送订单请求模型")
public class SendServiceOrderDTO {

    @ApiModelProperty(value = "订单id", required = true)
    @NotNull(message = "请选择订单")
    private Long id;

    @ApiModelProperty(value = "订单价格,维修价格不能低于1元", required = true)
    @NotNull(message = "请输入维修价格")
    @Positive(message = "价格必须为正数")
    private BigDecimal price;

}
