package com.onsiteservice.common.annotation.idempotent;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * @author 潘维吉
 * @date 2020/6/29 17:46
 * @email 406798106@qq.com
 * @description 在需要保证 接口幂等性 的Controller的方法上使用此注解
 * 注意查询和删除是天然的幂等性 不需要添加  新增和修改的接口添加
 */
@Target({ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
public @interface ApiIdempotent {
    long interval() default 1000L; // 默认1s  1s之内只能访问一次
}
