package com.onsiteservice.admin.security.handler;

import com.onsiteservice.core.config.MvcConfig;
import com.onsiteservice.core.result.Result;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.web.access.AccessDeniedHandler;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import static com.onsiteservice.core.result.ResultGenerator.failCustom;
import static org.springframework.http.HttpStatus.FORBIDDEN;

/**
 * @author 潘维吉
 * @date 2020/3/7 10:29
 * @email 406798106@qq.com
 * @description 自定义返异常回信息  当用户没有访问权限时的处理器
 */
public class CustomAccessDeniedHandler implements AccessDeniedHandler {

    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response, AccessDeniedException accessDeniedException) {
        Result result = failCustom(FORBIDDEN.value(), "拒绝访问");
        MvcConfig.responseResult(response, result);
    }

}
