package com.onsiteservice.admin.controller.sys;

import com.onsiteservice.admin.controller.sys.vo.LoginInitVO;
import com.onsiteservice.admin.security.pojo.AccountCredentials;
import com.onsiteservice.admin.service.sys.SysBusinessService;
import com.onsiteservice.common.annotation.user.CurrentUserId;
import com.onsiteservice.core.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

import static com.onsiteservice.core.result.ResultGenerator.success;

/**
 * @author 潘维吉
 * @date 2020/3/7 14:19
 * @email 406798106@qq.com
 * @description 业务控制类
 */
@Api(tags = "登录密码")
@RestController
@RequestMapping
@Validated
public class LoginController {

    @Resource
    private SysBusinessService sysBusinessService;

    @ApiOperation(value = "登录", notes = "作者: 潘维吉。 Spring Security处理, 不配置浏览器会出现CORS跨域问题")
    @PostMapping("login")
    public AccountCredentials login(@RequestBody AccountCredentials account) {
        return account;
    }


    @ApiOperation(value = "获取菜单、权限、用户")
    @GetMapping("login/init")
    public Result<LoginInitVO> init(@CurrentUserId Long userId) {
        return success(sysBusinessService.init(userId));
    }
}
