package com.onsiteservice.admin.controller.order.dto;

import com.onsiteservice.dao.common.page.PageParams;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

@Data
public class OrderPageDTO extends PageParams {

    @ApiModelProperty("订单号")
    private String orderNo;

    @ApiModelProperty("服务类型id")
    private Integer subclassId;

    @ApiModelProperty("客户服务手机号")
    private String phone;

    private String userName;

    @ApiModelProperty("期望上门时间")
    private Date expectArrivalTimeBegin;
    private Date expectArrivalTimeEnd;

    @ApiModelProperty("订单状态：1已预约，2已派单，3进行中，4完成，5取消，6已评价")
    private Integer orderStatus;

    @ApiModelProperty("创建时间(下单时间)")
    private Date createTimeBegin;
    private Date createTimeEnd;

    @ApiModelProperty("地址")
    private String address;

}
