package com.onsiteservice.admin.controller.home;

import com.onsiteservice.admin.service.home.dto.HomeNoticePageDTO;
import com.onsiteservice.common.annotation.dict.Dict;
import com.onsiteservice.common.annotation.user.CurrentUserId;
import com.onsiteservice.constant.constant.DictConstants;
import com.onsiteservice.entity.home.HomeNotice;
import com.onsiteservice.admin.service.home.HomeNoticeService;

import com.onsiteservice.core.result.Result;
import com.onsiteservice.dao.common.page.PageInfoVO;
import com.onsiteservice.dao.common.page.PageParams;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.NonNull;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import springfox.documentation.annotations.ApiIgnore;

import javax.annotation.Resource;
import javax.validation.constraints.Positive;

import static com.onsiteservice.core.result.ResultGenerator.success;
import static com.onsiteservice.core.result.ResultGenerator.fail;

/**
 * @author 商天翔
 * @date 2022-07-20 16:19
 * @description HomeNoticeController控制类
 */
@ApiIgnore
@Api(tags = "HomeNoticeController")
@RestController
@RequestMapping("/home/notice")
@Validated
public class HomeNoticeController {

    @Resource
    private HomeNoticeService homeNoticeService;


    @Dict(name = "releaseStatus", code = DictConstants.NOTICE_RELEASE_STATUS)
    @ApiOperation(value = "分页查询列表", notes = "作者: 商天翔")
    @PostMapping("/page")
    public Result<PageInfoVO> getPage(@RequestBody @NonNull @Validated HomeNoticePageDTO param) {
        return success(homeNoticeService.getPage(param), "获取分页列表");
    }

    @ApiOperation(value = "根据id查询", notes = "作者: 商天翔")
    @GetMapping("/{id}")
    public Result<HomeNotice> getDetails(@PathVariable @Positive Long id) {
        return success(homeNoticeService.getHomeNoticeMapper().selectByPrimaryKey(id), "根据id获取详情");
    }

    @ApiOperation(value = "新增或修改", notes = "作者: 商天翔")
    @PostMapping("/save-or-update")
    public Result saveOrUpdate(@RequestBody @NonNull @Validated HomeNotice homeNotice, @CurrentUserId Long userId) {
        return success(homeNoticeService.saveOrUpdate(homeNotice, userId), homeNotice.getId() == null ? "新增成功" : "修改成功");
    }

    @ApiOperation(value = "根据id删除", notes = "作者: 商天翔")
    @DeleteMapping("/{id}")
    public Result deleteById(@PathVariable @Positive Long id) {
        return success(homeNoticeService.getHomeNoticeMapper().deleteByPrimaryKey(id), "删除成功");
    }

}
