package com.onsiteservice.admin.controller.banner;

import com.onsiteservice.common.annotation.user.CurrentUserId;
import com.onsiteservice.entity.banner.Banner;
import com.onsiteservice.admin.service.banner.BannerService;

import com.onsiteservice.core.result.Result;
import com.onsiteservice.dao.common.page.PageInfoVO;
import com.onsiteservice.dao.common.page.PageParams;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.NonNull;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import springfox.documentation.annotations.ApiIgnore;

import javax.annotation.Resource;
import javax.validation.constraints.Positive;

import java.util.List;

import static com.onsiteservice.core.result.ResultGenerator.success;
import static com.onsiteservice.core.result.ResultGenerator.fail;

/**
 * @author 商天翔
 * @date 2022-07-12 14:37
 * @description BannerController控制类
 */
@ApiIgnore
@Api(tags = "BannerController")
@RestController
@RequestMapping("/banner")
@Validated
public class BannerController {

    @Resource
    private BannerService bannerService;


    @ApiOperation(value = "分页查询列表", notes = "作者: 商天翔")
    @PostMapping("/list")
    public Result<List> getPage() {
        return success(bannerService.getPage());
    }

    @ApiOperation(value = "根据id查询", notes = "作者: 商天翔")
    @GetMapping("/{id}")
    public Result<Banner> getDetails(@PathVariable @Positive Long id) {
        return success(bannerService.selectByPrimaryKey(id), "根据id获取详情");
    }

    @ApiOperation(value = "新增或修改", notes = "作者: 商天翔")
    @PostMapping("/save-or-update")
    public Result saveOrUpdate(@RequestBody @NonNull @Validated Banner banner, @CurrentUserId Long userId) {
        return success(bannerService.saveOrUpdate(banner, userId), banner.getId() == null ? "新增成功" : "修改成功");
    }

    @PutMapping("/enable")
    public Result enable(@RequestBody @NonNull @Validated Banner banner) {
        return success(bannerService.enable(banner));
    }

    @ApiOperation(value = "根据id删除", notes = "作者: 商天翔")
    @DeleteMapping("/{id}")
    public Result deleteById(@PathVariable @Positive Long id) {
        return success(bannerService.deleteOne(id), "删除成功");
    }

}
