package com.onsiteservice.entity.sys;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import javax.persistence.*;

import java.io.Serializable;
import java.util.Date;

@Getter
@Setter
@ToString
@ApiModel("系统业务操作表")
@Table(name = "sys_business_operate")
public class SysBusinessOperate implements Serializable {
    /**
     * 主键
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty("主键")
    private Long id;

    /**
     * 业务id
     */
    @Column(name = "business_id")
    @ApiModelProperty("业务id")
    private Long businessId;

    /**
     * 操作名称
     */
    @ApiModelProperty("操作名称")
    private String name;

    /**
     * 操作key 前端视图元素显示隐藏控制
     */
    @Column(name = "operate_key")
    @ApiModelProperty("操作key 前端视图元素显示隐藏控制")
    private String operateKey;

    /**
     * 修改人
     */
    @Column(name = "modify_by")
    @ApiModelProperty("修改人")
    private Long modifyBy;

    /**
     * 修改时间
     */
    @Column(name = "modify_time")
    @ApiModelProperty("修改时间")
    private Date modifyTime;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    @ApiModelProperty("创建人")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_time")
    @ApiModelProperty("创建时间")
    private Date createTime;

    private static final long serialVersionUID = 1L;

    @Transient
    private Boolean selected = false;
}