package com.onsiteservice.entity.sys;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

@Getter
@Setter
@ToString
@ApiModel("系统业务菜单表")
@Table(name = "sys_business")
public class SysBusiness implements Serializable {
    /**
     * 主键
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty("主键")
    private Long id;

    /**
     * 父级code
     */
    @Column(name = "parent_code")
    @ApiModelProperty("父级code")
    private String parentCode;

    /**
     * 业务编号
     */
    @ApiModelProperty("业务编号")
    private String code;

    /**
     * 业务名称
     */
    @ApiModelProperty("业务名称")
    private String name;

    /**
     * 菜单图标
     */
    @ApiModelProperty("菜单图标")
    private String icon;

    /**
     * 前端路径
     */
    @Column(name = "vr_path")
    @ApiModelProperty("前端路径")
    private String vrPath;

    /**
     * 前端router name
     */
    @Column(name = "vr_name")
    @ApiModelProperty("前端router name")
    private String vrName;

    /**
     * 前端组件包路径
     */
    @Column(name = "vr_component_path")
    @ApiModelProperty("前端组件包路径")
    private String vrComponentPath;

    /**
     * 前端重定向地址
     */
    @Column(name = "vr_redirect")
    @ApiModelProperty("前端重定向地址")
    private String vrRedirect;

    /**
     * 是否缓存 0: 不缓存 1: 缓存
     */
    @Column(name = "is_cache")
    @ApiModelProperty("是否缓存 0: 不缓存 1: 缓存")
    private Boolean isCache;

    /**
     * 是否在菜单中显示 0: 不显示 1: 显示
     */
    @Column(name = "is_show")
    @ApiModelProperty("是否在菜单中显示 0: 不显示 1: 显示")
    private Boolean isShow;

    /**
     * 显示排序号 数字越大优先级越小
     */
    @Column(name = "show_order")
    @ApiModelProperty("显示排序号 数字越大优先级越小")
    private Integer showOrder;

    /**
     * 修改人
     */
    @Column(name = "modify_by")
    @ApiModelProperty("修改人")
    private Long modifyBy;

    /**
     * 修改时间
     */
    @Column(name = "modify_time")
    @ApiModelProperty("修改时间")
    private Date modifyTime;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    @ApiModelProperty("创建人")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_time")
    @ApiModelProperty("创建时间")
    private Date createTime;

    private static final long serialVersionUID = 1L;
}