package com.onsiteservice.entity.banner;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import tk.mybatis.mapper.annotation.LogicDelete;

@Getter
@Setter
@ToString
@ApiModel("首页轮播图")
public class Banner implements Serializable {
    /**
     * 主键
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty("主键")
    private Long id;

    /**
     * 说明
     */
    @ApiModelProperty("说明")
    private String description;

    /**
     * 图片地址
     */
    @ApiModelProperty("图片地址")
    private String url;

    @Column(name = "mp_article")
    @ApiModelProperty("文章连接")
    private String mpArticle;

    /**
     * 跳转类型 0 不跳转 1 图片 ,其他业务
     */
    @ApiModelProperty("跳转类型 0 不跳转 1 图片 2 文章")
    private Integer type;

    /**
     * 跳转内容 如果是图片存url如果是资讯存id
     */
    @ApiModelProperty("跳转内容 如果是图片存url如果是资讯存id")
    private String target;

    /**
     * 是否启用
     */
    @ApiModelProperty("是否启用")
    private Boolean enabled;

    /**
     * 排序
     */
    @Column(name = "show_order")
    @ApiModelProperty("排序")
    private Integer showOrder;

    /**
     * 修改人
     */
    @Column(name = "modify_by")
    @ApiModelProperty("修改人")
    private Long modifyBy;

    /**
     * 修改时间
     */
    @Column(name = "modify_time")
    @ApiModelProperty("修改时间")
    private Date modifyTime;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    @ApiModelProperty("创建人")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_time")
    @ApiModelProperty("创建时间")
    private Date createTime;

    private static final long serialVersionUID = 1L;
}