package com.onsiteservice.core.result;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author 潘维吉
 * @date 2018-05-20
 * 响应码枚举，参考HTTP状态码的语义
 */
@AllArgsConstructor
@Getter
public enum ResultCodeEnum {
    //成功
    SUCCESS(200),
    //失败
    FAIL(400),
    //未认证
    UNAUTHORIZED(401),
    //未授权
    FORBIDDEN(403),
    //接口不存在
    NOT_FOUND(404),
    //内部服务错误
    INTERNAL_SERVER_ERROR(500);

    private final int code;

    /**
     * 重写toString方法 用于自定义枚举返回数据和格式
     *
     * @return 自定义枚举数据
     */
    @Override
    public String toString() {
        return "{'code':" + this.code + "}";
    }
}
