package com.onsiteservice.constant.constant;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;

import java.util.List;
import java.util.Map;

/**
 * 业务常量
 */
public class BizConstants {

    public static class UserConstants {
        public static final String ACCOUNT_NO = "accountNo";
        public static final String ROLE_TYPE = "roleType";
    }

    public static class OrderConstants {
        public static final String ORDER_ID = "orderId";
        public static final String ORDER_STATUS = "orderStatus";
        public static final long TIMEOUT_CANCEL_LIMIT = 1000 * 60 * 30;

        /**
         * 前后端订单状态映射
         */
        public static final Map<Integer, List<Integer>> FRONT_BACK_ORDER_STATUS_MAP = ImmutableMap.<Integer, List<Integer>>builder()
                .put(0, Lists.newArrayList(1, 2, 3, 4, 5, 6, 7)) // 全部
                .put(1, Lists.newArrayList(1, 2)) // 待受理
                .put(3, Lists.newArrayList(3)) // 待支付
                .put(4, Lists.newArrayList(4)) // 待派单
                .put(5, Lists.newArrayList(5)) // 服务中
                .put(6, Lists.newArrayList(6, 7)) // 已完成
                .build();

    }

    public static class FormatConstants {
        public static final String CATEGORY_SUBCLASS_SERVICE_NAME = "%s-%s";
    }

    public static class CommonConstants {
        public static final String RELEASE_STATUS = "releaseStatus";
        public static final String DELETED = "deleted";
    }

}
